require( "scripts/style.lua" );

function Restart()
	SendGameMessage( "restart" );
	SwapToModal("scripts/loading.lua");
	--SwapToModal("scripts/endless.lua");
end

is_endless = true;

SetState("StoryModeSessionTime",0);
SetState("MainMenuScreenTime",0);
SetState("ComicScreenTime",0);
SetState("MetaMapTime",0);
SetState("HelpScreenTime",0);

PropFontUpgrades = {
    standardFont,
    22,
    Color(0,0,0,255)
};


vWinBtn_X = kCenter+220;
vWinBtn_Y = kCenter+165;


MakeDialog
{
	-- Name the modal dialog
	name="Before test",
	Bitmap
	{
		name	= "backgroundimage",
		image	= "backgrounds/background_parking_placeholder";
		scale	= 1.0,
		w		= 100,
		h		= 100,
		
		Endless
		{
			x			= kCenter,
			y			= kCenter,
			w			= kMax,
			h			= kMax,
			level		= gLevelEndless,
			totalscore	= 0,
			fadespeed   = 0.75;
			
			SetStyle(ButtonStyle),
			Button
			{
				x 		= 140,
				y 		= 10,
				w		= 180,
				h		= 30,
				flags	= kHAlignCenter + kVAlignCenter,
				name	= "btn_upgrades",
				label	= "upgrades",
				font    = PropFontUpgrades,
				type 	= kPush,
				graphics = 
					{ 
						"buttons/long_button_up",
						"buttons/long_button_down",
						"buttons/long_button_over" 
					},
				command = function()
							SendGameMessage("button_upgrades");
							DoModal("scripts/upgrades.lua");
						  end
			},
			Button
			{
				x 		= 340,
				y 		= 10,
				w		= 180,
				h		= 30,
				flags	= kHAlignCenter + kVAlignCenter,
				name	= "btn_decors",
				label	= "decorations",
				font    = PropFontUpgrades,
				type 	= kPush,
				graphics = 
					{ 
						"buttons/long_button_up",
						"buttons/long_button_down",
						"buttons/long_button_over" 
					},
				command = function()
							SendGameMessage("button_decorations");
							DoModal("scripts/decorupgrades.lua");
						  end
			},
			---------- fail button  --------------
			SetStyle(ButtonStyle),
			Button
			{
				label 	= "retry",
				name	= "endgame_retry",
				font	=  {
							 standardFont,
							 16,
							 BlackColor
						   },
				x		= 470+26,
				y		= 400-4,
				hflip   = true,
				graphics = { "buttons/btn_a_normal","buttons/btn_a_down","buttons/btn_a_over" },
				command	= function()
							SendGameMessage("win_level");
						  end;
			},
			---------- main menu button  --------------
			SetStyle(ButtonStyle),
			Button
			{
				label 	= "mainmenu",
				name	= "endgame_mainmenu",
				font	=  {
							 standardFont,
							 16,
							 BlackColor
						   },
				x		= 235-23,
				y		= 400-4,
				graphics = { "buttons/btn_a_normal","buttons/btn_a_down","buttons/btn_a_over" },
				command	= function()
							SendGameMessage("quit");
						  end;
			},
			--------------------------------------------------------------------------------------------------------------------------------------------
			Text
			{
				name	= "text_openclose",
				x		= 759,
				y 		= 110,
				w		= 50,
				h		= 30,
				flags 	= kHAlignCenter + kVAlignTop,
				label   = "open",
				font	= { standardFont, 12, BlackColor },
			},
			-- ----------------------------------------------------------------------------------------
			-- Bitmap
			-- {
				-- image 	= "buttons/base_pause",
				-- x		= 0,
				-- y 		= 563,
			-- },
			SetStyle(ButtonStyle),
			Button
			{
				name	= "pause_button",
				label	= "pause",
				font	=  {
							 standardFont,
							 16,
							 BlackColor
						   },
				x		= kMax-107,
				y		= kMax-32,
				graphics = 
					{ 
						"buttons/btn_pause_norm",
						"buttons/btn_pause_down",
						"buttons/btn_pause_over" 
					},
				command	= function()
							SendGameMessage("pause");
							DoModal("scripts/pause.lua");
						  end;
			},
			-- Bitmap
			-- {
				-- image 	= "buttons/btn_pause_shadow",
				-- x		= 0,
				-- y 		= 568,
			-- },
			-- ----------------------------------------------------------------------------------------
			Bitmap
			{
				name 	= "blackfader",
				image   = "backgrounds/blackfull.png",
				x = kCenter,
				y = kCenter,
				w = kMax,
				h = kMax,				
			},
		},
		
		
		
	},
}


function RepeatLevel()
	SwapToModal("scripts/endless.lua");
end

function ExitToMainMenu()
	SendGameMessage( "quit" );
end

SetFocus( "btn_upgrades" );